<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */
?>

<div class="card card-post bg-gradient-1 border-0 px-1 py-1">
    <div class="card-body bg-transparent px-0 py-0">
        <div class="row no-gutters">
            <div class="col-12">
                <div class="card-thumbnail">
                    <img class="lazy w-100 h-100" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/loading.svg" data-src="<?php echo get_the_post_thumbnail_url( $post_id ); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
                </div>
            </div>
            <div class="col-12">
                <div class="card-content px-3 py-3">
                    <h4 class="d-none d-lg-block text-title text-white text-uppercase font-weight-bold mb-2">
                        <span class="font-weight-bold"><?php echo get_the_title( $post_id ); ?></span>
                    </h4>
                    <h5 class="d-block d-lg-none text-title text-white text-uppercase font-weight-bold mb-2">
                        <span class="font-weight-bold"><?php echo get_the_title( $post_id ); ?></span>
                    </h5>
                    <div class="row no-gutters align-items-center justify-content-between">
                        <div class="col-auto">
                            <p class="badge badge-sm bg-color-4 text-white text-center text-uppercase mb-0 px-2 py-2">
                                <span><i class="fa fa-calendar-alt"></i>&nbsp;<?php echo get_the_date( 'l, d F Y' ); ?></span>
                            </p>
                        </div>
                        <div class="col-auto">
                            <p class="badge badge-sm bg-color-4 text-white text-center text-uppercase mb-0 px-2 py-2">
                                <span><i class="fa fa-clock"></i>&nbsp;<?php echo get_the_date( 'h:i A' ); ?> WIB</span>
                            </p>
                        </div>
                    </div>
                    <p class="text-black text-justify line-height-small mt-2 mb-0">
                        <small class="text-white"><?php echo substr( get_the_excerpt( $post_id ), 0, 150 ); ?> . . .</small>
                    </p>
                    <div class="row no-gutters justify-content-center mt-3">
                        <div class="col-auto">
                            <a class="btn btn-sm bg-color-9 border-0 text-black font-weight-bold px-3 py-1 my-0" href="<?php echo get_the_permalink( $post_id ); ?>">
                                <span>Lihat selengkapnya</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
