<?php
/**
 * Template Name: Beranda
 * Template Post Type: page
 * @package web-buktijp
 * @since 1.0.0
 */

global $paged;

if (get_query_var( 'paged' )) {
    $paged = get_query_var( 'paged' );
} elseif (get_query_var( 'page' )) {
    $paged = get_query_var( 'page' );
} else {
    $paged = '1';
}

$buktijp = $exito->get_bukti_jp();

get_header();

?>

<section>
    <div class="container px-3 py-4">
        <h1 class="d-none d-lg-block page-title text-white text-center text-uppercase px-3 py-3 mb-0">
            <span>CARA BERMAIN</span>&nbsp;<span><?php echo get_bloginfo( 'name' ); ?></span>
        </h1>
        <h5 class="d-block d-lg-none page-title text-white text-center text-uppercase px-3 py-3 mb-0">
            <span>CARA BERMAIN</span>&nbsp;<span><?php echo get_bloginfo( 'name' ); ?></span>
        </h5>
        <div class="row no-gutters justify-content-center pt-4">
            <?php if ( $buktijp->have_posts() ) : while ( $buktijp->have_posts() ) : $buktijp->the_post(); ?>
                <div class="col-12 col-lg-3 px-1 mb-4 d-flex">
                    <?php
                        set_query_var( 'post_id', $buktijp->ID );
                        get_template_part( 'components/part-card', 'post' );
                    ?>
                </div>
            <?php endwhile; endif; ?>
        </div>
        <div class="pagination-wrapper text-center">
            <div class="paginate">
                <?php
                    $pagi_attr = [
                        'total'     => $buktijp->max_num_pages,
                        'prev_text' => '«',
                        'next_text' => '»',
                        'current'   => max( 1, $paged ),
                    ];

                    echo paginate_links( $pagi_attr );
                ?>
            </div>
        </div>
    </div>
</section>

<?php if ( have_posts() ) : while ( have_posts() ) : ?>
    <section class="content-wrapper bg-color-2">
        <div class="container px-0 py-0">
            <div class="content content-home text-white text-justify px-3 py-3 px-lg-0 py-lg-4">
                <?php the_post(); the_content(); ?>
            </div>
        </div>
    </section>
<?php endwhile; endif; ?>

<?php

get_footer();
