<?php
/**
 * @package web-buktijp
 * @since 1.0.0
 */

$beranda = get_pages([ 'post_type' => 'page', 'meta_key' => '_wp_page_template', 'meta_value' => 'page-beranda.php' ]);

get_header();

?>

<?php if ( have_posts() ) : while ( have_posts() ) : ?>
<section>
    <div class="container px-3 py-4 px-lg-0 pb-lg-5">
        <h1 class="d-none d-lg-block text-white text-uppercase mb-2">
            <span><?php echo get_the_title(); ?></span>
        </h1>
        <h5 class="d-block d-lg-none text-white text-uppercase mb-2">
            <span><?php echo get_the_title(); ?></span>
        </h5>
        <p class="text-white mb-4">
            <span><i class="fa fa-calendar-alt"></i></span>
            <span><?php echo get_the_date( 'l, d F Y' ); ?> WIB</span>
            <span>&ensp;|&ensp;</span>
            <span><i class="fa fa-clock"></i></span>
            <span><?php echo get_the_date( 'h:i A' ); ?> WIB</span>
        </p>
        <div class="row no-gutters">
            <div class="col-12 col-lg">
                <div class="card card-blog bg-transparent px-0 py-0 mb-4 mb-lg-0">
                    <div class="card-header border-0 bg-color-2 px-0 py-0">
                        <div class="card-thumbnail">
                            <img class="lazy w-100 h-100" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/loading.svg" data-src="<?php echo get_the_post_thumbnail_url( get_the_ID() ); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
                        </div>
                    </div>
                    <div class="card-body bg-color-8 px-4 py-4">
                        <p class="text-black text-justify mb-0"><?php the_post(); the_content(); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-auto pl-lg-4"><?php get_template_part( 'components/part-card', 'sidebar' ); ?></div>
        </div>
    </div>
</section>
<?php endwhile; endif; ?>

<section class="content-wrapper bg-color-2">
    <div class="container px-0 py-0">
        <div class="content content-home text-white text-justify px-3 py-3 px-lg-0 py-lg-4">
            <?php echo apply_filters( 'the_content', $beranda[0]->post_content ); ?>
        </div>
    </div>
</section>

<?php

get_footer();
